#pragma once
#include <vector>
#include <string>
#include <map>
#include "xmlreader.h"
#include <xtl.h>
#include <xui.h>
#include <xuiapp.h>
#include "threadlock.h"
#include "tools.h"
#include "freestyledash.h"

using namespace std;


class ContentItem {
public:
	ContentItem()
	{
		type = 0;
		version = 0;
		Exist = false;
		source = -1;
		c_type = 6;

		i_Icon = false;
		i_BoxArt = false;
		i_Background = false;
		i_SSCount = 0;
		Favourite = false;

		discno = 0;
		disccn = 0;

		recent = 0;
	}

	void CreateWStrs()
	{

		// create icon path
		if (i_Icon)
			icon = datapath_x + L"artwork/" + imagefolder + L"/icon.png";
		if (i_BoxArt)
			boxart = datapath_x + L"artwork/" + imagefolder + L"/boxart.jpg";
		//
		/*w_title = strtowstr(title);
		w_path = strtowstr(path);
		w_desc = strtowstr(desc);
		w_id = strtowstr(id);
		w_icon = strtowstr(icon);
		w_boxart = strtowstr(boxart);
		w_imagefolder = strtowstr(imagefolder);
		w_manuf = strtowstr(manuf);
		w_mediaid = strtowstr(mediaid);

		vector<string>::iterator itr;
		w_genres.clear();
		for (itr = genres.begin() ; itr != genres.end() ; itr++)
		{
			//DebugMsg("Converting genre %s",(*itr).c_str());
			w_genres.push_back(strtowstr(*itr));
		}*/
	}

	bool Exist;
	wstring title;
	wstring path;
	int type;
	wstring packagetype;
	wstring desc;
	wstring id;
	wstring icon;
	wstring boxart;
	wstring manuf;
	wstring mediaid;
	/*wstring w_title;
	wstring w_path;
	wstring w_desc;
	wstring w_id;
	wstring w_icon;
	wstring w_boxart;
	wstring w_manuf;
	wstring w_mediaid;*/

	int version;
	int discno;
	int disccn;
	int source;
	int recent;

	bool Favourite;

	wstring imagefolder;

	bool i_Icon;
	bool i_BoxArt;
	int i_SSCount; 
	int i_CurrSS;
	bool i_Background;

	int c_type;
	wstring shortpath;

	vector <wstring> genres;
};

class GenreItem {
public:
	GenreItem()
	{
	}

	wstring title;
	wstring icon;
};

typedef struct _ContentItems {
    int nItems;
    ContentItem *pItems[1000];
} ContentItems;

typedef struct _GenreItems {
    int nItems;
    GenreItem *pItems[1000];
} GenreItems;

struct TypePaths {
	vector<wstring> path;
};

class ContentList
{
public:
	vector<ContentItem*> Content;
	map<int,vector<GenreItem*>*> Genres;
	map<int,TypePaths*> Paths;
	map<wstring,ContentItem*> PathLookup;
	int LastRecent;

	int HorizOverscan;
	int VertOverscan;
	
	int FanSpeed;

	bool Loaded;
	bool AnyChanged;
	// thread loading progress
	wstring current;

	wstring sub1;
	int sub1ProgCur;
	int sub1ProgMax;

	wstring sub2;
	int sub2ProgCur;
	int sub2ProgMax;

	wstring xboxip;
	int port;
	wstring ftpuser;
	wstring ftppass;

	wstring debugip;
	int debugport;

	wstring skin;

	ContentList(void);
	~ContentList(void);

	void LoadConfig();
	void LoadContentXML();
	ContentItems* GetItems(int type,wstring genre = L"",bool OnlyFavs = false,bool OnlyRecent = false);
	GenreItems* GetGenres(int type);
	void BuildGenreList();
	wstring GetGameList(int type, wstring genre);
	void LoadNonXMLItems();
	void ScanPath(int type, wstring path);
	void ScanGame(int type, wstring path, wstring search);
	void SortAll();
	void Initialize();
	void ScanXBLAPath(int type, wstring path);
	void ScanXBLAGame(int type, wstring path, wstring id);
	void ScanGODGame(int type, wstring path, wstring id);
	void ScanXBOX1GOD(int type, wstring path, wstring id);
	void SaveContentList();
	void ConvertAllToWide();
	void XEXParse(ContentItem * item);
	void XBLAParse(ContentItem * item);
	void GODParse(ContentItem * item);
	void XBOX1Parse(ContentItem * item);
	void LoadFavourites();
	void MakeShortPath(ContentItem * item);
	bool ExtractLiveImage(wstring destfile, wstring sourcefile, int whichimg = 0);
	void LaunchGame(ContentItem * item);
	void ClearDeleted();
	void SetCurrent(wstring newtext);
	void SetSub1(wstring newtext);
	void SetSub2(wstring newtext);
	void SortMaxRecents();
};

extern ContentList cl;
 